 aR  d  w  mP9      h	 oU    nSystem-wide$DEBUG
	NAME		StringToReal

CGROUP  GROUP CODE
DGROUP  GROUP DATA
ASSUME  CS:CGROUP, DS:DGROUP

DATA    SEGMENT PARA PUBLIC 'DATA'
DATA    ENDS

CODE    SEGMENT BYTE PUBLIC 'CODE'

	PUBLIC	StringToReal

	EXTRN	FreeString: NEAR
	EXTRN	StringToInteger: NEAR
	EXTRN	NewString: NEAR

stringType STRUC
	strLen		DW ?
	strMax		DW ?
	strchars	DB 200 DUP (?)
stringType ENDS

true		   	EQU 01
false		   	EQU 00
scientific       	EQU 0FFFEH
ten			DW 10
$EJECT 
PUBLIC jumptoerror, jumptotheend, itsok, skip, skip1, while1top, while1bottom, while2top, while2bottom, posexpfor, negexp, negexpfor, expdone, theend, positive, error
;------------------------------------------------------------
StringToReal PROC NEAR
;FUNCTION StringToReal (str: StringPtr; VAR converted: Boolean): LongReal;
; 
; This routine converts the specified string into a long real number.
; All internal calculations are done with temporary real accuracy (80 bits).
;
; Register usage
;	Parameters	None
;       Destroyed	All
;	Returned	Top of 8087 stack = converted number
;------------------------------------------------------------

localBytes	EQU 1
local		EQU [BP-localBytes]
locals STRUC
;---------------------
negative	DB ?
;---------------------
locals ENDS

paramBytes	EQU 8
param		EQU [BP]
params STRUC
;---------------------
oldBP		DW ?
returnIP	DW ?
;---------------------
pConverted	DD ?
str		DD ?
;---------------------
params ENDS
converted	EQU ES:[DI]
string		EQU DS:[SI]

;Prologue
	PUSH	BP
	MOV	BP,SP
	SUB	SP,localBytes
	PUSH	DS
;---------------------

	FLDZ				; TOS = SUM
;	LEA	DI, local.sum		; sum = 0.0
;	MOV	AX, SS
;	MOV	ES, AX
;	XOR	AX, AX
;	MOV	CX, 5
;	CLD
;	REP	STOSW

;	LEA	DI, local.fracDivisor	; fracDivisor = 10.0
;	LEA	SI, ten
;	MOV	AX, CS
;	MOV	DS, AX
;	MOV	CX, 5
;	REP	MOBSW
	FILD	WORD PTR ten
	FST	ST(4)			; ST(3) will contain fracDivisor
	FSTP	ST(5)			; ST(4) will contain the constant 10.0

	LES	DI, param.pConverted	; converted = true
	MOV	BYTE PTR converted, true

	LDS	SI, param.str

	CMP	SI, 0FFFFH		; IF str <> NIL THEN
	JNE	itsOK
	MOV	AX, DS
	CMP	AX, 0FFFFH
	JNZ	itsOk

jumpToError:				; Stubs to get around short calls
	JMP	error
jumpToTheEnd:
	JMP	theEnd

itsOK:
	MOV	BX, string.strLen	; BX contains the string length

	OR	BX, BX			; IF str.len > 0 THEN
	JZ	jumpToError

	; remove trailing blanks
	MOV	AX, DS
	MOV	ES, AX			; Set up the seg for the SCASB
	MOV	AL, ' '
	LEA	DI, string.strChars[BX]	; SkipReverseBytes(str.chars[1], ' ', str.len
	MOV	CX, BX			;                  length)
	STD
	REPZ 	SCASB
	INC	CX
	MOV	BX, CX		    	; Length = last non-blank character
	JCXZ	jumpToError		; IF len <= 0 THEN error

	; remove leading blanks
	MOV	DX, CX
	LEA	DI, string.strChars[1]	; SkipBytes(str.chars[1], ' ', length, index)
	CLD
	REPZ	SCASB			; CX is now the index to the first char
	SUB	DX, CX
	MOV	CX, DX

	XCHG	BX, CX			; BX = index, CX = len
	MOV	DX, BX			; Save the initial index
	CMP	BYTE PTR string.strChars[BX], '+'
	JNZ	skip			; IF string.chars(index) = '+' THEN
	INC	BX			; index = index + 1
skip:
	MOV	local.negative, false	; negative = false
	CMP	BYTE PTR string.strChars[BX], '-'
	JNZ	skip1			; IF string.chars(index) = '-' THEN
	INC	BX			; BEGIN index = index + 1
	MOV	local.negative, true	;       negative = true
skip1:					; END
	MOV	DX, 1
	PUSH	DX			; Save the initial index
while1Top:
	CMP	BX, CX			; WHILE (index <= length) AND
	JG	while1Bottom
	MOV	AL, string.strChars[BX]
	CMP	AL, '0'			;       (string.chars(index) >= '0') AND
	JL	while1Bottom
	CMP	AL, '9'			;       (string.chars(index) <= '9') DO
	JG	while1Bottom
					;   BEGIN
	DEC	DX
	JZ	skipTheFirstTime	;   IF NOT firstTime THEN
	FMUL	ST, ST(4)		;     sum = sum * 10;
skipTheFirstTime:
	SUB	AL, '0'			;     sum = sum + (chars[index] - '0')
	XOR	AH, AH
	PUSH	AX
	MOV	DI, SP
	FIADD	WORD PTR SS:[DI]
	POP	AX

	INC	BX			;   index = index + 1
	JMP	SHORT while1Top		;   END;

while1Bottom:
	POP	DX			; Restore the initial index
	CMP	BX, CX			; IF (index <= length) AND
	JG	jumpToTheEnd

	CMP	BYTE PTR string.strChars[BX], '.'
	JNE	while2Bottom		;    (string.chars(index) = '.' THEN
					;   BEGIN
	INC	BX			;   index = index + 1

while2Top:
	CMP	BX, CX			;   WHILE (index <= lenght) AND
	JG	jumpToTheEnd			
	MOV	AL, string.strChars[BX]
	CMP	AL, '0'			;         (string.chars(index) >= '0') AND
	JL	while2Bottom
	CMP	AL, '9'			;         (string.chars(index) <= '9') DO
	JG	while2Bottom

					;     BEGIN
	SUB	AL, '0'			;     sum = sum + ((chars[index] - '0')
	XOR	AH, AH			;          / fracDivisor)
	PUSH	AX
	MOV	DI, SP
	FILD	WORD PTR SS:[DI]
	POP	AX
	FDIV	ST, ST(4)
	FADD

	FXCH	ST(3)
	FMUL	ST, ST(4)		;    fracDivisor = fracDivisor * 10
	FXCH	ST(3)

	INC	BX			;    index = index + 1
	JMP	SHORT while2Top		;    END;
					; END;
while2Bottom:
	CMP	BX, CX			; IF (index <= length) AND
	JG	theEnd

	MOV	AL, string.strChars[BX]
	AND	AL, 0DFH			; make it uppercase
	CMP	AL, 'E'			;    ((string.chars(index) = 'e') OR
	JNE	theEnd			;    (string.chars(index) = 'E')) THEN
					;   BEGIN
	CMP	BX, DX			;   IF index = initialIndex THEN
	JE	error			;     Error - it's a number like E1

	INC	BX			;   index = index + 1

	SUB	CX, BX			;   expStr = NewString (length - index + 1)
	INC	CX
	PUSH	BX
	PUSH	CX
	PUSH	CX
	CALL	NewString		; ES:[BX] points to the string

	POP	CX
	MOV	ES:[BX].strLen, CX	;   expStr.len = expStr.max

	MOV	DI, BX		     	;   MovBytes(chars[index], expStr^.chars[1],
	POP	BX			;            expStr^.max)

	PUSH	ES			; Save the string ptr to free it
	PUSH	DI
	PUSH	ES			; Set up the param for stringToInteger
	PUSH	DI
	LDS	SI, param.str
	LEA	SI, string.strChars[BX]
	LEA	DI, ES:[DI].strChars[1]
	CLD
	REP	MOVSB

	LES	DI, param.pConverted
	PUSH	ES
	PUSH	DI
	CALL	StringToInteger

	PUSH	AX			; Save the integer

	PUSH	SS			; Use the stack as the tempory var for 
	MOV	AX, SP			; FreeString
	ADD	AX, 4
	PUSH	AX
	CALL	FreeString		; Free the string allocated

	POP	AX
	ADD	SP, 4			; Throw away the NIL pointer

	LES	DI, param.pConverted	;   IF converted THEN
	CMP	BYTE PTR converted, true
	JNZ	error

	MOV	CX, AX
	OR	AX, AX
	JZ	expDone
	JL	negExp			; IF exp > 0 THEN

posExpFor:				;   FOR i = 1 TO exp DO
	FMUL	ST, ST(4)		;     sum = sum * 10.0
	LOOP	posExpFor
	JMP	SHORT expDone
					; ELSE
negExp:					;   FOR i = 1 to -exp DO
	NEG	CX
negExpFor:
	FDIV	ST, ST(4)		;     sum = sum / 10.0
	LOOP	negExpFor

expDone:
	XOR	BX, BX			; index = length + 1
	MOV	CX, BX
	INC	BX

theEnd:
	CMP	local.negative, true
	JNZ	positive
	FCHS
positive:
	INC	CX   			; IF index <> length + 1 THEN error
	CMP	CX, BX
	JZ	epilogue

error:
	LES	DI, param.pConverted
	MOV	BYTE PTR converted, false
	FFREE	ST(0)
	FINCSTP
	FLDZ

;---------------------
epilogue:
	FFREE	ST(4)
	FFREE	ST(3)
	POP	DS
	MOV	SP,BP
	POP	BP
	RET	paramBytes

StringToReal ENDP

PURGE localBytes, locals, local, paramBytes, params, param, oldBP, returnIP, epilogue

CODE  ENDS

END
